<?php
// Hata göstermeyi kapatalım
error_reporting(0);
ini_set('display_errors', 0);

// User Agent kaydı
$userAgent = $_SERVER['HTTP_USER_AGENT'] . "\n";
file_put_contents("user_agents.txt", $userAgent, FILE_APPEND);

// İstatistik dosyasının yolu
$statsFile = 'site_stats.json';

// Yardımcı fonksiyonlar
function getDateKey($date = null) { return $date ?: date('Y-m-d'); }
function getWeekKey($date = null) { $ts = $date ? strtotime($date) : time(); return date('o-W', $ts); }
function getMonthKey($date = null) { $ts = $date ? strtotime($date) : time(); return date('Y-m', $ts); }
function getYesterdayKey() { return date('Y-m-d', strtotime('-1 day')); }

// Başlangıç verilerini kontrol et
if (!file_exists($statsFile)) {
    $stats = ['visits' => ['total' => 0, 'days' => [], 'weeks' => [], 'months' => []], 'urls' => []];
    file_put_contents($statsFile, json_encode($stats));
}

// Mevcut istatistikleri oku
$stats = json_decode(file_get_contents($statsFile), true);

// Ziyaretleri güncelle
$today = getDateKey();
$yesterday = getYesterdayKey();
$thisWeek = getWeekKey();
$thisMonth = getMonthKey();
$stats['visits']['total'] = ($stats['visits']['total'] ?? 0) + 1;
$stats['visits']['days'][$today] = ($stats['visits']['days'][$today] ?? 0) + 1;
$stats['visits']['weeks'][$thisWeek] = ($stats['visits']['weeks'][$thisWeek] ?? 0) + 1;
$stats['visits']['months'][$thisMonth] = ($stats['visits']['months'][$thisMonth] ?? 0) + 1;

// Link tıklama takibi
if (isset($_GET['popup']) && $_GET['popup'] == 1 && isset($_GET['link'])) {
    $popupKey = 'POPUP';
    if (!isset($stats['urls'][$popupKey])) {
        $stats['urls'][$popupKey] = ['total' => 0, 'days' => [], 'weeks' => [], 'months' => []];
    }
    $stats['urls'][$popupKey]['total']++;
    $stats['urls'][$popupKey]['days'][$today] = ($stats['urls'][$popupKey]['days'][$today] ?? 0) + 1;
    $stats['urls'][$popupKey]['weeks'][$thisWeek] = ($stats['urls'][$popupKey]['weeks'][$thisWeek] ?? 0) + 1;
    $stats['urls'][$popupKey]['months'][$thisMonth] = ($stats['urls'][$popupKey]['months'][$thisMonth] ?? 0) + 1;
    file_put_contents($statsFile, json_encode($stats));
    $redirectUrl = urldecode($_GET['link']);
    echo "<script>window.location.replace('" . addslashes($redirectUrl) . "');</script>";
    exit;
}

if (isset($_GET['url'])) {
    $clickedUrl = urldecode($_GET['url']);
    if (!isset($stats['urls'][$clickedUrl])) {
        $stats['urls'][$clickedUrl] = ['total' => 0, 'days' => [], 'weeks' => [], 'months' => []];
    }
    $stats['urls'][$clickedUrl]['total']++;
    $stats['urls'][$clickedUrl]['days'][$today] = ($stats['urls'][$clickedUrl]['days'][$today] ?? 0) + 1;
    $stats['urls'][$clickedUrl]['weeks'][$thisWeek] = ($stats['urls'][$clickedUrl]['weeks'][$thisWeek] ?? 0) + 1;
    $stats['urls'][$clickedUrl]['months'][$thisMonth] = ($stats['urls'][$clickedUrl]['months'][$thisMonth] ?? 0) + 1;
    file_put_contents($statsFile, json_encode($stats));
    header("Location: " . $clickedUrl);
    exit;
}

// İstatistikleri kaydet
file_put_contents($statsFile, json_encode($stats));

// DATA.JSON OKU
$dataFile = __DIR__ . '/data.json';
$data = json_decode(file_get_contents($dataFile), true);
$meta = $data['meta'] ?? ['title' => 'Premium Bonus', 'description' => 'En güncel bonus fırsatları'];
$banner_titles = $data['banner_titles'] ?? [];
$popup = $data['popup'] ?? ['title' => 'Günün Sitesi', 'button_text' => 'HEMEN GİR', 'button_link' => '#'];
$sites = $data['sites'] ?? [];
$contacts = $data['contacts'] ?? [];
$top_banners = $data['top_banners'] ?? [];
$bottom_banners = $data['bottom_banners'] ?? [];
$ticker_top = $data['ticker_top'] ?? ['text' => 'En güncel kampanyalar', 'button_text' => 'Hemen Git', 'button_link' => '#'];
$ticker_bottom = $data['ticker_bottom'] ?? ['text' => 'Güvenli yönlendirme için beklemede kal', 'button_text' => 'Detay', 'button_link' => '#'];

// İstatistikleri görüntüle
$showStats = isset($_GET['stats']);
?>

<!DOCTYPE html>
<html lang="tr">
<head>
<!-- Google tag (gtag.js) -->
<script async src="https://www.googletagmanager.com/gtag/js?id=G-1T1S5SRZ0Y"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());

  gtag('config', 'G-1T1S5SRZ0Y');
</script>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= htmlspecialchars($meta['title']) ?></title>
    <meta name="description" content="<?= htmlspecialchars($meta['description']) ?>">
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        body { background-color: #111827; font-family: 'Inter', sans-serif; color: #e5e7eb; padding-top: 50px; padding-bottom: 60px; }
        /* Kartlar eş yükseklikte */
        .site-grid { display:grid; grid-template-columns:repeat(2,minmax(0,1fr)); gap:0.9rem; align-items:stretch; }
        @media(min-width:1024px){ .site-grid{grid-template-columns:repeat(4,minmax(0,1fr));} }
        .site-card { background: #1f2937; border: 1px solid #374151; border-radius: 14px; padding: 0.65rem; box-shadow: 0 10px 30px rgba(0,0,0,0.25); transition: transform .2s, box-shadow .2s; display:flex; flex-direction:column; height:100%; gap:0.35rem; }
        .site-card:hover { transform: translateY(-2px); box-shadow: 0 14px 34px rgba(0,0,0,0.3); }
        .site-card .logo-wrap { width: 70px; height:70px; border-radius:12px; background:#111827; display:grid; place-items:center; margin:0 auto; }
        .site-card img { width: 64px; height: 52px; object-fit: contain; display:block; }
        .site-card .bonus-area { min-height: 42px; display:flex; flex-direction:column; align-items:center; justify-content:center; gap:2px; width:100%; }
        .site-badge { padding:3px 8px; border-radius:9999px; font-size:11px; background:rgba(16,185,129,.16); color:#6ee7b7; border:1px solid rgba(16,185,129,.35); }
        .site-stars { color:#f59e0b; font-size:0.9rem; }
        .site-btn { display:inline-flex; align-items:center; justify-content:center; gap:6px; padding:9px 10px; border-radius:10px; background:linear-gradient(135deg,#f97316,#f59e0b); color:#fff; font-weight:700; width:100%; box-shadow:0 8px 22px rgba(249,115,22,.28); margin-top:auto; }
        .bonus-chip { padding:4px 8px; border-radius:10px; background:rgba(59,130,246,.12); border:1px solid rgba(59,130,246,.25); color:#bfdbfe; font-size:0.85rem; }
        .clamp-1 { display:-webkit-box; -webkit-line-clamp:1; -webkit-box-orient:vertical; overflow:hidden; }
        .clamp-2 { display:-webkit-box; -webkit-line-clamp:2; -webkit-box-orient:vertical; overflow:hidden; }
        .marquee { width:100%; overflow:hidden; }
        .marquee-text { display:inline-block; white-space:nowrap; animation: marquee 9s linear infinite; }
        .marquee-text::after { content:" • " attr(data-text) " • " attr(data-text); }
        @keyframes marquee { 0% { transform: translateX(0); } 100% { transform: translateX(-50%); } }
        /* Banner grid: mobil 3 kolon, fazla olursa alt satır */
        .banner-grid { display:grid; grid-template-columns:repeat(3,minmax(0,1fr)); gap:0.4rem; }
        @media(min-width:768px){ .banner-grid{grid-template-columns:repeat(4,minmax(0,1fr));} }
        .banner-grid img { width:100%; height:52px; object-fit:contain; background:#0b1220; }
        /* Sabit kayan yazılar (üst-alt) */
        .ticker { position:fixed; left:0; right:0; z-index:60; background:#0ea5e9; color:#0b132b; display:flex; align-items:center; height:30px; }
        .ticker-top { top:0; }
        .ticker-bottom { bottom:0; }
        .ticker-track { white-space:nowrap; animation:ticker-move 9s linear infinite; padding:4px 8px; font-weight:700; width:calc(100% - 120px); }
        @keyframes ticker-move { 0%{transform:translateX(0);} 100%{transform:translateX(-50%);} }
        .ticker-btn { position:absolute; right:6px; top:4px; bottom:4px; display:inline-flex; align-items:center; gap:6px; padding:0 12px; border-radius:9999px; background:#0b132b; color:#22d3ee; font-weight:800; font-size:12px; }
        /* Popup canlı renk (sabit zıt tonlar) */
        .popup-box { background:#0b1220; color:#e5e7eb; border:1px solid #22d3ee; box-shadow:0 20px 50px rgba(0,0,0,0.45); width: 260px; padding: 12px; overflow:hidden; }
    </style>
</head>
<body>
    <!-- Sabit kayan yazı + buton -->
    <div class="ticker ticker-top">
        <div class="ticker-track marquee-text" data-text="<?= htmlspecialchars($ticker_top['text'] ?? '') ?>"><?= htmlspecialchars($ticker_top['text'] ?? '') ?></div>
        <?php if (!empty($ticker_top['button_link'])): ?>
            <a class="ticker-btn" href="index.php?url=<?= urlencode($ticker_top['button_link']) ?>" target="_blank">
                <i class="fas fa-bolt"></i> <?= htmlspecialchars($ticker_top['button_text'] ?? 'Git') ?>
            </a>
        <?php endif; ?>
    </div>

    <main class="container mx-auto px-3 py-0">
        <!-- Şerit Banner -->
        <div class="w-full relative overflow-hidden mb-0">
            <div id="banner-strip" class="w-full flex items-center justify-center py-1 px-2 rounded-xl shadow-2xl bg-gradient-to-r from-orange-500 via-red-500 to-orange-400 text-white">
                <i class="fas fa-crown mr-2 text-yellow-300 text-lg md:text-2xl drop-shadow-lg"></i>
                <span id="dynamic-banner-title" class="font-extrabold text-center tracking-wide whitespace-nowrap text-base sm:text-lg md:text-2xl lg:text-3xl w-full overflow-hidden" style="line-height:1.1; text-overflow:ellipsis;">
                     <?= htmlspecialchars($banner_titles[0] ?? 'Premium Deneme Bonusu Fırsatları') ?> 
                 </span> 
             </div>
        </div>

        <!-- Üst Bannerlar -->
        <div class="banner-grid mb-0">
            <?php foreach ($top_banners as $index => $banner): ?>
                <a class="bg-gray-800 rounded-lg shadow-md overflow-hidden hover:shadow-lg transition block"
                   href="index.php?url=<?= urlencode($banner['url']) ?>" target="_blank">
                    <?php if (!empty($banner['image']) && !empty($banner['url'])): ?>
                        <img src="<?= htmlspecialchars($banner['image']) ?>" alt="<?= htmlspecialchars($banner['alt']) ?>" class="w-full h-16 object-cover">
                    <?php else: ?>
                        <div class="w-full h-16 grid place-items-center text-gray-300">Banner <?= $index + 1 ?></div>
                    <?php endif; ?>
                </a>
            <?php endforeach; ?>
        </div>
        
        <!-- Kart Grid (Mobil 2, Masaüstü 4) -->
        <div class="site-grid mb-4" id="site-grid"></div>

        <!-- İletişim Kartları -->
        <?php if (!empty($contacts)): ?>
        <div class="mt-6 space-y-2">
            <div class="flex items-center justify-between">
                <h3 class="text-lg font-semibold text-white">İletişim / Destek</h3>
                  </div>
            <div class="site-grid" id="contact-grid"></div>
                  </div>
        <?php endif; ?>

        <!-- Alt Bannerlar -->
        <div class="banner-grid mb-0">
            <?php foreach ($bottom_banners as $index => $banner): ?>
                <a class="bg-gray-800 rounded-lg shadow-md overflow-hidden hover:shadow-lg transition block"
                   href="index.php?url=<?= urlencode($banner['url']) ?>" target="_blank">
                    <?php if (!empty($banner['image']) && !empty($banner['url'])): ?>
                        <img src="<?= htmlspecialchars($banner['image']) ?>" alt="<?= htmlspecialchars($banner['alt']) ?>" class="w-full h-16 object-cover">
                    <?php else: ?>
                        <div class="w-full h-16 grid place-items-center text-gray-300">Banner <?= $index + 1 ?></div>
                    <?php endif; ?>
                </a>
            <?php endforeach; ?>
        </div>

        <!-- İstatistikler -->
        <?php if ($showStats): ?>
            <div class="mt-10 bg-gray-800 rounded-xl p-6">
                <h2 class="text-xl font-bold mb-4 text-orange-400 flex items-center"><i class="fas fa-chart-line mr-2"></i> Site İstatistikleri</h2>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div>
                        <div class="flex justify-between items-center mb-2"><span class="text-gray-300">Bugün:</span><span class="font-bold text-orange-400"><?= $stats['visits']['days'][$today] ?? 0; ?></span></div>
                        <div class="flex justify-between items-center mb-2"><span class="text-gray-300">Dün:</span><span class="font-bold text-orange-400"><?= $stats['visits']['days'][$yesterday] ?? 0; ?></span></div>
                        <div class="flex justify-between items-center mb-2"><span class="text-gray-300">Bu Hafta:</span><span class="font-bold text-orange-400"><?= $stats['visits']['weeks'][$thisWeek] ?? 0; ?></span></div>
                        <div class="flex justify-between items-center mb-2"><span class="text-gray-300">Bu Ay:</span><span class="font-bold text-orange-400"><?= $stats['visits']['months'][$thisMonth] ?? 0; ?></span></div>
                        <div class="flex justify-between items-center"><span class="text-gray-300">Toplam:</span><span class="font-bold text-orange-400"><?= $stats['visits']['total'] ?? 0; ?></span></div>
                    </div>
                    <div>
                        <div class="text-gray-300 mb-3">Tıklama İstatistikleri:</div>
                        <div class="overflow-x-auto">
                            <table class="w-full text-sm text-center rounded-lg border border-gray-700 bg-gray-900">
                                <thead>
                                    <tr class="bg-gray-700 text-orange-300">
                                        <th class="px-2 py-1">Link</th>
                                        <th class="px-2 py-1">Bugün</th>
                                        <th class="px-2 py-1">Dün</th>
                                        <th class="px-2 py-1">Bu Hafta</th>
                                        <th class="px-2 py-1">Bu Ay</th>
                                        <th class="px-2 py-1">Toplam</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $siteNames = [];
                                    if (file_exists($dataFile)) {
                                        $dataJson = json_decode(file_get_contents($dataFile), true);
                                        if (isset($dataJson['sites'])) {
                                            foreach ($dataJson['sites'] as $site) {
                                                if (!empty($site['url']) && !empty($site['name'])) {
                                                    $siteNames[$site['url']] = $site['name'];
                                                }
                                            }
                                        }
                                        $popupLink = $dataJson['popup']['button_link'] ?? '';
                                    } else { $popupLink = ''; }
                                    $rows = [];
                                    if (isset($stats['urls']['POPUP'])) {
                                        $rows[] = ['type' => 'popup', 'name' => 'POPUP', 'data' => $stats['urls']['POPUP']];
                                    }
                                    foreach ($stats['urls'] as $url => $dataRow) {
        if ($url === 'POPUP') continue;
                                        $isSite = isset($siteNames[$url]);
        $rows[] = ['type' => $isSite ? 'site' : 'url', 'name' => $isSite ? $siteNames[$url] : $url, 'data' => $dataRow];
    }
                                    foreach ($rows as $row): ?>
                                        <tr>
                                            <td class="break-all max-w-[120px] text-xs">
                                                <?php if ($row['type'] === 'popup'): ?>
                                                    <span class="font-bold text-purple-400">POPUP</span>
                                                <?php elseif ($row['type'] === 'site'): ?>
                                                    <span class="font-bold text-orange-300"><?= htmlspecialchars($row['name']) ?></span>
                                                <?php else: ?>
                                                    <a href="<?= htmlspecialchars($row['name']) ?>" class="underline text-orange-400" target="_blank"><?= htmlspecialchars($row['name']) ?></a>
                                                <?php endif; ?>
                                            </td>
                                            <td class="font-semibold text-red-400 text-xs drop-shadow"><?= $row['data']['days'][$today] ?? 0 ?></td>
                                            <td class="font-semibold text-yellow-300 text-xs drop-shadow"><?= $row['data']['days'][$yesterday] ?? 0 ?></td>
                                            <td class="font-semibold text-blue-300 text-xs drop-shadow"><?= $row['data']['weeks'][$thisWeek] ?? 0 ?></td>
                                            <td class="font-semibold text-pink-300 text-xs drop-shadow"><?= $row['data']['months'][$thisMonth] ?? 0 ?></td>
                                            <td class="font-extrabold text-green-400 text-xs drop-shadow-lg"><?= $row['data']['total'] ?? 0 ?></td>
                                        </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>
    </main>

    <?php if (!$showStats): ?>
        <!-- Popup -->
    <div id="popup-site" class="fixed bottom-16 right-6 z-50 popup-box rounded-xl shadow-2xl p-3 w-64 hidden">
            <div class="flex items-start gap-3">
                <div class="h-10 w-10 rounded-xl bg-white/10 text-white grid place-items-center border border-white/20">
                    <span>💰</span>
            </div>
                <div class="flex-1">
                    <div class="text-sm font-bold">✅ <?= htmlspecialchars($popup['title']) ?></div>
                <div class="text-xs text-gray-100 mt-1 marquee overflow-hidden" style="max-width:100%; overflow:hidden;">
                    <span class="marquee-text" data-text="<?= htmlspecialchars($popup['desc'] ?? '') ?>"><?= htmlspecialchars($popup['desc'] ?? '') ?></span>
                </div>
            </div>
            <button onclick="document.getElementById('popup-site').style.display='none'" class="text-gray-200 hover:text-white ml-1 shrink-0"><i class="fas fa-times"></i></button>
            </div>
            <a href="index.php?popup=1&link=<?= urlencode($popup['button_link']) ?>" target="_blank" class="mt-3 block bg-orange-500 hover:bg-orange-600 text-white text-center font-bold py-2.5 rounded-lg transition border-2 border-cyan-400">🔥 <?= htmlspecialchars($popup['button_text']) ?></a>
            </div>
        <?php endif; ?>

    <footer class="bg-gray-900 text-white py-6 mt-8">
        <div class="container mx-auto px-4 text-center text-gray-400 text-sm">
            © 2025. 18 yaş altı kullanamaz.
        </div>
    </footer>
    <div class="ticker ticker-bottom">
        <div class="ticker-track marquee-text" data-text="<?= htmlspecialchars($ticker_bottom['text'] ?? '') ?>"><?= htmlspecialchars($ticker_bottom['text'] ?? '') ?></div>
        <?php if (!empty($ticker_bottom['button_link'])): ?>
            <a class="ticker-btn" href="index.php?url=<?= urlencode($ticker_bottom['button_link']) ?>" target="_blank">
                <i class="fas fa-arrow-right"></i> <?= htmlspecialchars($ticker_bottom['button_text'] ?? 'Git') ?>
            </a>
        <?php endif; ?>
    </div>

        <script>
        // Banner başlıkları döngü
        const bannerTitles = <?php echo json_encode($banner_titles, JSON_UNESCAPED_UNICODE); ?>;
        let bannerIndex = 0;
        function updateBannerTitle() {
            document.getElementById('dynamic-banner-title').textContent = bannerTitles[bannerIndex] || 'Güncel Bonuslar';
            bannerIndex = (bannerIndex + 1) % bannerTitles.length;
        }
        setInterval(updateBannerTitle, 2500);
        updateBannerTitle();

        // Kart grid doldur
        const sites = <?php echo json_encode($sites, JSON_UNESCAPED_UNICODE); ?>;
        const contacts = <?php echo json_encode($contacts, JSON_UNESCAPED_UNICODE); ?>;
        const grid = document.getElementById('site-grid');
        grid.innerHTML = '';
        sites.forEach((s, idx) => {
            const stars = Number(s.stars || 4);
            let starsHtml = '';
            for (let i = 1; i <= 5; i++) {
                if (i <= stars) starsHtml += '<i class="fas fa-star"></i>';
                else if (stars + 0.5 === i) starsHtml += '<i class="fas fa-star-half-alt"></i>';
                else starsHtml += '<i class="far fa-star"></i>';
            }
            const badge = s.licensed_badge && s.licensed_badge.show ? `<span class="site-badge">${s.licensed_badge.text}</span>` : '';
            grid.innerHTML += `
                <div class="site-card">
                    <div class="flex flex-col items-center gap-2">
                        <div class="logo-wrap"><img src="${s.logo}" alt="${s.name}"></div>
                        <div class="text-center">
                            <div class="font-bold text-lg clamp-1">${s.name}</div>
                            <div>${badge}</div>
                        </div>
                </div>
                    <div class="flex flex-col items-center gap-1 bonus-area marquee">
                        <span class="bonus-chip clamp-1 marquee-text" data-text="${s.bonus}">${s.bonus}</span>
                </div>
                    <div class="site-stars flex justify-center gap-1 mt-1" style="margin-bottom:0.1rem">${starsHtml}</div>
                    <a href="index.php?url=${encodeURIComponent(s.url)}" target="_blank" class="site-btn">${s.button_text || 'GİRİŞ YAP'} <i class="fas fa-arrow-right"></i></a>
            </div>
            `;
        });

        // İletişim kartları
        const contactGrid = document.getElementById('contact-grid');
        if (contactGrid) {
            contactGrid.innerHTML = '';
            contacts.forEach(c => {
                contactGrid.innerHTML += `
                    <div class="site-card">
                        <div class="flex flex-col items-center gap-2">
                            <div class="logo-wrap"><img src="${c.logo}" alt="${c.name}"></div>
                            <div class="text-center">
                                <div class="font-bold text-lg clamp-1">${c.name}</div>
            </div>
        </div>
                        <div class="flex flex-col items-center gap-1 bonus-area marquee">
                            <span class="bonus-chip clamp-1">${c.text}</span>
                        </div>
                        <a href="index.php?url=${encodeURIComponent(c.url)}" target="_blank" class="site-btn">${c.button_text || 'GİT'} <i class="fas fa-arrow-right"></i></a>
                    </div>
                `;
            });
        }

        // Popup otomatik göster
        const popupEl = document.getElementById('popup-site');
        if (popupEl) {
            setTimeout(() => popupEl.style.display = 'block', 1800);
            setTimeout(() => popupEl.style.display = 'none', 9000);
        }
    </script>
    <center><script id="_wauzyv">var _wau = _wau || []; _wau.push(["dynamic", "c5l6smr3qg", "zyv", "1c4587ffffff", "small"]);</script><script async src="//waust.at/d.js"></script></center>
</body>
</html>

